<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <form class="form-inline float-right">
                            <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"
                                name="cari">
                            <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                Cari!</button>
                        </form>

                        <button class="btn btn-default shadow-sm">
                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                <input type="checkbox" id="cekall">
                                <label for="cekall">
                                </label>
                            </div>
                        </button>
                        <button class="btn btn-danger" id="pilih_hapus"><i class="fa fa-trash"></i>
                            Hapus</button>
                        <table class="table table-bordered table-hover myTable tab mt-2">
                            <thead>
                                <tr>
                                    <th width="3%">No</th>
                                    <th>#</th>
                                    <th>Nota</th>
                                    <th>Atas Nama</th>
                                    <th>Tanggal</th>
                                    <th>Petugas</th>
                                    <th>Kurir</th>
                                    <th>Ongkir</th>
                                    <th>Total</th>
                                    <th>Pembelian</th>
                                    <th>Dibayar</th>
                                    <th>Kembali</th>
                                    <th>Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="viewpenjualan">
                                @forelse ($penjualan as $p)
                                    <tr>
                                        <td class="text-center"> {{ $no++ }}</td>
                                        <td class="text-center">
                                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                                <input type="checkbox" name="id[]" id="cek{{ $p->id }}"
                                                    class="ceklis" value="{{ $p->id }}">
                                                <label for="cek{{ $p->id }}">
                                                </label>
                                            </div>
                                        </td>
                                        <td>{{ $p->kd_transaksi }}</td>
                                        <td style="background-color: rgb(248, 248, 228)">
                                            {{ $p->member->nm_member }}</td>
                                        <td>{{ tgl_inf($p->created_at) }}</td>
                                        <td style="background-color: rgb(228, 246, 248)">
                                            {{ $p->user->nm_user }}</td>
                                        <td style="background-color: rgb(252, 242, 242)">
                                            {{ empty($p->kurir) ? '-' : $p->kurir->karyawan->nm_karyawan }}</td>
                                        <td class="text-right">{{ number_format($p->ongkir, 0, ',', '.') }}</td>
                                        <td class="text-right">{{ number_format($p->total, 0, ',', '.') }}</td>
                                        <td>{!! $p->jns_transaksi == 'OFF'
                                            ? ' <span class="text-danger">Offline</span>'
                                            : ' <span class="text-success">Online</span>' !!}
                                        </td>
                                        <td class="text-right">{{ number_format($p->dibayar, 0, ',', '.') }}</td>
                                        <td class="text-right">
                                            {{ number_format($p->dibayar - $p->total, 0, ',', '.') }}</td>
                                        <td class="text-center">
                                            <button class="btn btn-info btn-sm detail" data-id="{{ $p->id }}"><i
                                                    class="fa fa-search mr-2"></i>
                                                Detail</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="20">Belum ada transaksi</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        {{ $penjualan->links('components.admin.pagination') }}
                    </div>
                </div>
            </div>


        </div>
        <!-- /.card -->

    </section>

    {{-- detail  --}}
    <div class="modal fade" id="detail">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    Detail Order
                </div>
                <div class="modal-body" id="vdetail">

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <x-slot:foot>
        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/transaksi.js"></script>
    </x-slot:foot>
</x-admin.contents>
